/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.util;

import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.RechercheObjets;
import fr.asip.cps3.exemple.vues.dialogs.SaisieCodeNbEssais;
import fr.asip.cps3.exemple.vues.dialogs.SaisieRecyclage;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.awt.Color;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TraitementsUtil {
    private static Logger log;
    public static final long AUCUN_CODE_RETOUR = -1L;
    public static final int TYPE_OBJET_CERTIFICAT = 1;
    public static final int TYPE_OBJET_CLE_PUBLIQUE = 2;
    public static final int TYPE_OBJET_CLE_PRIVE = 3;
    public static final int TYPE_OBJET_DONNEES_APPLICATIVES = 4;
    public static final int TYPE_ACTION_RETRAIT_CARTE = 1;
    public static final int TYPE_ACTION_INSERTION_CARTE = 2;
    public static final int TYPE_ACTION_RETRAIT_LECTEUR = 3;
    public static final int TYPE_ACTION_CONNEXION_LECTEUR = 4;
    private static char[] caracteresHexa;
    private static byte[] nibbleCorrespondant;

    public static String getHexadecimal(byte[] byArray, Integer n) {
        if (byArray != null) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
            int n2 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(caracteresHexa[(byArray[i] & 0xF0) >>> 4]);
                stringBuffer.append(caracteresHexa[byArray[i] & 0xF]);
                if (n == null) continue;
                if (++n2 == n) {
                    stringBuffer.append("\n");
                    n2 = 0;
                    continue;
                }
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static byte[] getOctetsSansFormatage(String string) throws IllegalArgumentException {
        if (string != null) {
            string = string.replaceAll("\n", "");
            int n = (string = string.replaceAll(" ", "")).length();
            if ((n & 1) != 0) {
                throw new IllegalArgumentException("getOctetsSansFormatage n\u00e9cessite une nombre paire de caract\u00e8res hexad\u00e9cimaux");
            }
            byte[] byArray = new byte[n / 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4 = TraitementsUtil.charToNibble(string.charAt(n2));
                int n5 = TraitementsUtil.charToNibble(string.charAt(n2 + 1));
                byArray[n3] = (byte)(n4 << 4 | n5);
                n2 += 2;
                ++n3;
            }
            return byArray;
        }
        return null;
    }

    private static int charToNibble(char c) throws IllegalArgumentException {
        if (c > 'f') {
            throw new IllegalArgumentException("Caract\u00e8re hexad\u00e9cimal invalide: " + c);
        }
        byte by = nibbleCorrespondant[c];
        if (by < 0) {
            throw new IllegalArgumentException("Caract\u00e8re hexad\u00e9cimal invalide: " + c);
        }
        return by;
    }

    public static String getNomAlgo(long l) {
        if (l == 0L) {
            return "CKM_RSA_PKCS_KEY_PAIR_GEN";
        }
        if (l == 1L) {
            return "CKM_RSA_PKCS";
        }
        if (l == 2L) {
            return "CKM_RSA_9796";
        }
        if (l == 3L) {
            return "CKM_RSA_X_509";
        }
        if (l == 4L) {
            return "CKM_MD2_RSA_PKCS";
        }
        if (l == 5L) {
            return "CKM_MD5_RSA_PKCS";
        }
        if (l == 6L) {
            return "CKM_SHA1_RSA_PKCS";
        }
        if (l == 7L) {
            return "CKM_RIPEMD128_RSA_PKCS";
        }
        if (l == 8L) {
            return "CKM_RIPEMD160_RSA_PKCS";
        }
        if (l == 9L) {
            return "CKM_RSA_PKCS_OAEP";
        }
        if (l == 10L) {
            return "CKM_RSA_X9_31_KEY_PAIR_GEN";
        }
        if (l == 11L) {
            return "CKM_RSA_X9_31";
        }
        if (l == 12L) {
            return "CKM_SHA1_RSA_X9_31";
        }
        if (l == 13L) {
            return "CKM_RSA_PKCS_PSS";
        }
        if (l == 14L) {
            return "CKM_SHA1_RSA_PKCS_PSS";
        }
        if (l == 16L) {
            return "CKM_DSA_KEY_PAIR_GEN";
        }
        if (l == 17L) {
            return "CKM_DSA";
        }
        if (l == 18L) {
            return "CKM_DSA_SHA1";
        }
        if (l == 32L) {
            return "CKM_DH_PKCS_KEY_PAIR_GEN";
        }
        if (l == 33L) {
            return "CKM_DH_PKCS_DERIVE";
        }
        if (l == 48L) {
            return "CKM_X9_42_DH_KEY_PAIR_GEN";
        }
        if (l == 49L) {
            return "CKM_X9_42_DH_DERIVE";
        }
        if (l == 50L) {
            return "CKM_X9_42_DH_HYBRID_DERIVE";
        }
        if (l == 51L) {
            return "CKM_X9_42_MQV_DERIVE";
        }
        if (l == 256L) {
            return "CKM_RC2_KEY_GEN";
        }
        if (l == 257L) {
            return "CKM_RC2_ECB";
        }
        if (l == 258L) {
            return "CKM_RC2_CBC";
        }
        if (l == 259L) {
            return "CKM_RC2_MAC";
        }
        if (l == 260L) {
            return "CKM_RC2_MAC_GENERAL";
        }
        if (l == 261L) {
            return "CKM_RC2_CBC_PAD";
        }
        if (l == 272L) {
            return "CKM_RC4_KEY_GEN";
        }
        if (l == 273L) {
            return "CKM_RC4";
        }
        if (l == 288L) {
            return "CKM_DES_KEY_GEN";
        }
        if (l == 289L) {
            return "CKM_DES_ECB";
        }
        if (l == 290L) {
            return "CKM_DES_CBC";
        }
        if (l == 291L) {
            return "CKM_DES_MAC";
        }
        if (l == 292L) {
            return "CKM_DES_MAC_GENERAL";
        }
        if (l == 293L) {
            return "CKM_DES_CBC_PAD";
        }
        if (l == 304L) {
            return "CKM_DES2_KEY_GEN";
        }
        if (l == 305L) {
            return "CKM_DES3_KEY_GEN";
        }
        if (l == 306L) {
            return "CKM_DES3_ECB";
        }
        if (l == 307L) {
            return "CKM_DES3_CBC";
        }
        if (l == 308L) {
            return "CKM_DES3_MAC";
        }
        if (l == 309L) {
            return "CKM_DES3_MAC_GENERAL";
        }
        if (l == 310L) {
            return "CKM_DES3_CBC_PAD";
        }
        if (l == 320L) {
            return "CKM_CDMF_KEY_GEN";
        }
        if (l == 321L) {
            return "CKM_CDMF_ECB";
        }
        if (l == 322L) {
            return "CKM_CDMF_CBC";
        }
        if (l == 323L) {
            return "CKM_CDMF_MAC";
        }
        if (l == 324L) {
            return "CKM_CDMF_MAC_GENERAL";
        }
        if (l == 325L) {
            return "CKM_CDMF_CBC_PAD";
        }
        if (l == 512L) {
            return "CKM_MD2";
        }
        if (l == 513L) {
            return "CKM_MD2_HMAC";
        }
        if (l == 514L) {
            return "CKM_MD2_HMAC_GENERAL";
        }
        if (l == 528L) {
            return "CKM_MD5";
        }
        if (l == 529L) {
            return "CKM_MD5_HMAC";
        }
        if (l == 530L) {
            return "CKM_MD5_HMAC_GENERAL";
        }
        if (l == 544L) {
            return "CKM_SHA_1";
        }
        if (l == 545L) {
            return "CKM_SHA_1_HMAC";
        }
        if (l == 546L) {
            return "CKM_SHA_1_HMAC_GENERAL";
        }
        if (l == 560L) {
            return "CKM_RIPEMD128";
        }
        if (l == 561L) {
            return "CKM_RIPEMD128_HMAC";
        }
        if (l == 562L) {
            return "CKM_RIPEMD128_HMAC_GENERAL";
        }
        if (l == 576L) {
            return "CKM_RIPEMD160";
        }
        if (l == 577L) {
            return "CKM_RIPEMD160_HMAC";
        }
        if (l == 578L) {
            return "CKM_RIPEMD160_HMAC_GENERAL";
        }
        if (l == 768L) {
            return "CKM_CAST_KEY_GEN";
        }
        if (l == 769L) {
            return "CKM_CAST_ECB";
        }
        if (l == 770L) {
            return "CKM_CAST_CBC";
        }
        if (l == 771L) {
            return "CKM_CAST_MAC";
        }
        if (l == 772L) {
            return "CKM_CAST_MAC_GENERAL";
        }
        if (l == 773L) {
            return "CKM_CAST_CBC_PAD";
        }
        if (l == 784L) {
            return "CKM_CAST3_KEY_GEN";
        }
        if (l == 785L) {
            return "CKM_CAST3_ECB";
        }
        if (l == 786L) {
            return "CKM_CAST3_CBC";
        }
        if (l == 787L) {
            return "CKM_CAST3_MAC";
        }
        if (l == 788L) {
            return "CKM_CAST3_MAC_GENERAL";
        }
        if (l == 789L) {
            return "CKM_CAST3_CBC_PAD";
        }
        if (l == 800L) {
            return "CKM_CAST5_KEY_GEN";
        }
        if (l == 800L) {
            return "CKM_CAST128_KEY_GEN";
        }
        if (l == 801L) {
            return "CKM_CAST5_ECB";
        }
        if (l == 801L) {
            return "CKM_CAST128_ECB";
        }
        if (l == 802L) {
            return "CKM_CAST5_CBC";
        }
        if (l == 802L) {
            return "CKM_CAST128_CBC";
        }
        if (l == 803L) {
            return "CKM_CAST5_MAC";
        }
        if (l == 803L) {
            return "CKM_CAST128_MAC";
        }
        if (l == 804L) {
            return "CKM_CAST5_MAC_GENERAL";
        }
        if (l == 804L) {
            return "CKM_CAST128_MAC_GENERAL";
        }
        if (l == 805L) {
            return "CKM_CAST5_CBC_PAD";
        }
        if (l == 805L) {
            return "CKM_CAST128_CBC_PAD";
        }
        if (l == 816L) {
            return "CKM_RC5_KEY_GEN";
        }
        if (l == 817L) {
            return "CKM_RC5_ECB";
        }
        if (l == 818L) {
            return "CKM_RC5_CBC";
        }
        if (l == 819L) {
            return "CKM_RC5_MAC";
        }
        if (l == 820L) {
            return "CKM_RC5_MAC_GENERAL";
        }
        if (l == 821L) {
            return "CKM_RC5_CBC_PAD";
        }
        if (l == 832L) {
            return "CKM_IDEA_KEY_GEN";
        }
        if (l == 833L) {
            return "CKM_IDEA_ECB";
        }
        if (l == 834L) {
            return "CKM_IDEA_CBC";
        }
        if (l == 835L) {
            return "CKM_IDEA_MAC";
        }
        if (l == 836L) {
            return "CKM_IDEA_MAC_GENERAL";
        }
        if (l == 837L) {
            return "CKM_IDEA_CBC_PAD";
        }
        if (l == 848L) {
            return "CKM_GENERIC_SECRET_KEY_GEN";
        }
        if (l == 864L) {
            return "CKM_CONCATENATE_BASE_AND_KEY";
        }
        if (l == 866L) {
            return "CKM_CONCATENATE_BASE_AND_DATA";
        }
        if (l == 867L) {
            return "CKM_CONCATENATE_DATA_AND_BASE";
        }
        if (l == 868L) {
            return "CKM_XOR_BASE_AND_DATA";
        }
        if (l == 869L) {
            return "CKM_EXTRACT_KEY_FROM_KEY";
        }
        if (l == 880L) {
            return "CKM_SSL3_PRE_MASTER_KEY_GEN";
        }
        if (l == 881L) {
            return "CKM_SSL3_MASTER_KEY_DERIVE";
        }
        if (l == 882L) {
            return "CKM_SSL3_KEY_AND_MAC_DERIVE";
        }
        if (l == 883L) {
            return "CKM_SSL3_MASTER_KEY_DERIVE_DH";
        }
        if (l == 884L) {
            return "CKM_TLS_PRE_MASTER_KEY_GEN";
        }
        if (l == 885L) {
            return "CKM_TLS_MASTER_KEY_DERIVE";
        }
        if (l == 886L) {
            return "CKM_TLS_KEY_AND_MAC_DERIVE";
        }
        if (l == 887L) {
            return "CKM_TLS_MASTER_KEY_DERIVE_DH";
        }
        if (l == 896L) {
            return "CKM_SSL3_MD5_MAC";
        }
        if (l == 897L) {
            return "CKM_SSL3_SHA1_MAC";
        }
        if (l == 912L) {
            return "CKM_MD5_KEY_DERIVATION";
        }
        if (l == 913L) {
            return "CKM_MD2_KEY_DERIVATION";
        }
        if (l == 914L) {
            return "CKM_SHA1_KEY_DERIVATION";
        }
        if (l == 928L) {
            return "CKM_PBE_MD2_DES_CBC";
        }
        if (l == 929L) {
            return "CKM_PBE_MD5_DES_CBC";
        }
        if (l == 930L) {
            return "CKM_PBE_MD5_CAST_CBC";
        }
        if (l == 931L) {
            return "CKM_PBE_MD5_CAST3_CBC";
        }
        if (l == 932L) {
            return "CKM_PBE_MD5_CAST5_CBC";
        }
        if (l == 932L) {
            return "CKM_PBE_MD5_CAST128_CBC";
        }
        if (l == 933L) {
            return "CKM_PBE_SHA1_CAST5_CBC";
        }
        if (l == 933L) {
            return "CKM_PBE_SHA1_CAST128_CBC";
        }
        if (l == 934L) {
            return "CKM_PBE_SHA1_RC4_128";
        }
        if (l == 935L) {
            return "CKM_PBE_SHA1_RC4_40";
        }
        if (l == 936L) {
            return "CKM_PBE_SHA1_DES3_EDE_CBC";
        }
        if (l == 937L) {
            return "CKM_PBE_SHA1_DES2_EDE_CBC";
        }
        if (l == 938L) {
            return "CKM_PBE_SHA1_RC2_128_CBC";
        }
        if (l == 939L) {
            return "CKM_PBE_SHA1_RC2_40_CBC";
        }
        if (l == 944L) {
            return "CKM_PKCS5_PBKD2";
        }
        if (l == 960L) {
            return "CKM_PBA_SHA1_WITH_SHA1_HMAC";
        }
        if (l == 1024L) {
            return "CKM_KEY_WRAP_LYNKS";
        }
        if (l == 1025L) {
            return "CKM_KEY_WRAP_SET_OAEP";
        }
        if (l == 4096L) {
            return "CKM_SKIPJACK_KEY_GEN";
        }
        if (l == 4097L) {
            return "CKM_SKIPJACK_ECB64";
        }
        if (l == 4098L) {
            return "CKM_SKIPJACK_CBC64";
        }
        if (l == 4099L) {
            return "CKM_SKIPJACK_OFB64";
        }
        if (l == 4100L) {
            return "CKM_SKIPJACK_CFB64";
        }
        if (l == 4101L) {
            return "CKM_SKIPJACK_CFB32";
        }
        if (l == 4102L) {
            return "CKM_SKIPJACK_CFB16";
        }
        if (l == 4103L) {
            return "CKM_SKIPJACK_CFB8";
        }
        if (l == 4104L) {
            return "CKM_SKIPJACK_WRAP";
        }
        if (l == 4105L) {
            return "CKM_SKIPJACK_PRIVATE_WRAP";
        }
        if (l == 4106L) {
            return "CKM_SKIPJACK_RELAYX";
        }
        if (l == 4112L) {
            return "CKM_KEA_KEY_PAIR_GEN";
        }
        if (l == 4113L) {
            return "CKM_KEA_KEY_DERIVE";
        }
        if (l == 4128L) {
            return "CKM_FORTEZZA_TIMESTAMP";
        }
        if (l == 4144L) {
            return "CKM_BATON_KEY_GEN";
        }
        if (l == 4145L) {
            return "CKM_BATON_ECB128";
        }
        if (l == 4146L) {
            return "CKM_BATON_ECB96";
        }
        if (l == 4147L) {
            return "CKM_BATON_CBC128";
        }
        if (l == 4148L) {
            return "CKM_BATON_COUNTER";
        }
        if (l == 4149L) {
            return "CKM_BATON_SHUFFLE";
        }
        if (l == 4150L) {
            return "CKM_BATON_WRAP";
        }
        if (l == 4160L) {
            return "CKM_ECDSA_KEY_PAIR_GEN";
        }
        if (l == 4160L) {
            return "CKM_EC_KEY_PAIR_GEN";
        }
        if (l == 4161L) {
            return "CKM_ECDSA";
        }
        if (l == 4162L) {
            return "CKM_ECDSA_SHA1";
        }
        if (l == 4176L) {
            return "CKM_ECDH1_DERIVE";
        }
        if (l == 4177L) {
            return "CKM_ECDH1_COFACTOR_DERIVE";
        }
        if (l == 4178L) {
            return "CKM_ECMQV_DERIVE";
        }
        if (l == 4192L) {
            return "CKM_JUNIPER_KEY_GEN";
        }
        if (l == 4193L) {
            return "CKM_JUNIPER_ECB128";
        }
        if (l == 4194L) {
            return "CKM_JUNIPER_CBC128";
        }
        if (l == 4195L) {
            return "CKM_JUNIPER_COUNTER";
        }
        if (l == 4196L) {
            return "CKM_JUNIPER_SHUFFLE";
        }
        if (l == 4197L) {
            return "CKM_JUNIPER_WRAP";
        }
        if (l == 4208L) {
            return "CKM_FASTHASH";
        }
        if (l == 4224L) {
            return "CKM_AES_KEY_GEN";
        }
        if (l == 4225L) {
            return "CKM_AES_ECB";
        }
        if (l == 4226L) {
            return "CKM_AES_CBC";
        }
        if (l == 4227L) {
            return "CKM_AES_MAC";
        }
        if (l == 4228L) {
            return "CKM_AES_MAC_GENERAL";
        }
        if (l == 4229L) {
            return "CKM_AES_CBC_PAD";
        }
        if (l == 8192L) {
            return "CKM_DSA_PARAMETER_GEN";
        }
        if (l == 8193L) {
            return "CKM_DH_PKCS_PARAMETER_GEN";
        }
        if (l == 8194L) {
            return "CKM_X9_42_DH_PARAMETER_GEN";
        }
        if (l == 0x80000000L) {
            return "CKM_VENDOR_DEFINED";
        }
        if (l == 336L) {
            return "CKM_DES_OFB64";
        }
        if (l == 337L) {
            return "CKM_DES_OFB8";
        }
        if (l == 338L) {
            return "CKM_DES_CFB64";
        }
        if (l == 339L) {
            return "CKM_DES_CFB8";
        }
        if (l == 592L) {
            return "CKM_SHA256";
        }
        if (l == 593L) {
            return "CKM_SHA256_HMAC";
        }
        if (l == 594L) {
            return "CKM_SHA256_HMAC_GENERAL";
        }
        if (l == 608L) {
            return "CKM_SHA384";
        }
        if (l == 609L) {
            return "CKM_SHA384_HMAC";
        }
        if (l == 610L) {
            return "CKM_SHA384_HMAC_GENERAL";
        }
        if (l == 624L) {
            return "CKM_SHA512";
        }
        if (l == 625L) {
            return "CKM_SHA512_HMAC";
        }
        if (l == 626L) {
            return "CKM_SHA512_HMAC_GENERAL";
        }
        if (l == 888L) {
            return "CKM_TLS_PRF";
        }
        if (l == 915L) {
            return "CKM_SHA256_KEY_DERIVATION";
        }
        if (l == 916L) {
            return "CKM_SHA384_KEY_DERIVATION";
        }
        if (l == 917L) {
            return "CKM_SHA512_KEY_DERIVATION";
        }
        if (l == 976L) {
            return "CKM_WTLS_PRE_MASTER_KEY_GEN";
        }
        if (l == 977L) {
            return "CKM_WTLS_MASTER_KEY_DERIVE";
        }
        if (l == 978L) {
            return "CKM_WTLS_MASTER_KEY_DERVIE_DH_ECC";
        }
        if (l == 979L) {
            return "CKM_WTLS_PRF";
        }
        if (l == 980L) {
            return "CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE";
        }
        if (l == 981L) {
            return "CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE";
        }
        if (l == 1280L) {
            return "CKM_CMS_SIG";
        }
        if (l == 64L) {
            return "CKM_SHA256_RSA_PKCS";
        }
        if (l == 65L) {
            return "CKM_SHA384_RSA_PKCS";
        }
        if (l == 66L) {
            return "CKM_SHA512_RSA_PKCS";
        }
        if (l == 67L) {
            return "CKM_SHA256_RSA_PKCS_PSS";
        }
        if (l == 68L) {
            return "CKM_SHA384_RSA_PKCS_PSS";
        }
        if (l == 69L) {
            return "CKM_SHA512_RSA_PKCS_PSS";
        }
        if (l == 4240L) {
            return "CKM_BLOWFISH_KEY_GEN";
        }
        if (l == 4241L) {
            return "CKM_BLOWFISH_CBC";
        }
        if (l == 4242L) {
            return "CKM_TWOFISH_KEY_GEN";
        }
        if (l == 4243L) {
            return "CKM_TWOFISH_CBC";
        }
        if (l == 4352L) {
            return "CKM_DES_ECB_ENCRYPT_DATA";
        }
        if (l == 4353L) {
            return "CKM_DES_CBC_ENCRYPT_DATA";
        }
        if (l == 4354L) {
            return "CKM_DES3_ECB_ENCRYPT_DATA";
        }
        if (l == 4355L) {
            return "CKM_DES3_CBC_ENCRYPT_DATA";
        }
        if (l == 4356L) {
            return "CKM_AES_ECB_ENCRYPT_DATA";
        }
        if (l == 4357L) {
            return "CKM_AES_CBC_ENCRYPT_DATA";
        }
        return Long.toString(l);
    }

    public static String getNomTypeCle(long l) {
        String string = "inconnu";
        if (l == 31L) {
            string = new String("CKK_AES");
        } else if (l == 28L) {
            string = new String("CKK_BATON");
        } else if (l == 22L) {
            string = new String("CKK_CAST");
        } else if (l == 24L) {
            string = new String("CKK_CAST128");
        } else if (l == 23L) {
            string = new String("CKK_CAST3");
        } else if (l == 24L) {
            string = new String("CKK_CAST5");
        } else if (l == 30L) {
            string = new String("CKK_CDMF");
        } else if (l == 19L) {
            string = new String("CKK_DES");
        } else if (l == 20L) {
            string = new String("CKK_DES2");
        } else if (l == 21L) {
            string = new String("CKK_DES3");
        } else if (l == 2L) {
            string = new String("CKK_DH");
        } else if (l == 1L) {
            string = new String("CKK_DSA");
        } else if (l == 3L) {
            string = new String("CKK_EC");
        } else if (l == 3L) {
            string = new String("CKK_ECDSA");
        } else if (l == 16L) {
            string = new String("CKK_GENERIC_SECRET");
        } else if (l == 26L) {
            string = new String("CKK_IDEA");
        } else if (l == 29L) {
            string = new String("CKK_JUNIPER");
        } else if (l == 5L) {
            string = new String("CKK_KEA");
        } else if (l == 17L) {
            string = new String("CKK_RC2");
        } else if (l == 18L) {
            string = new String("CKK_RC4");
        } else if (l == 25L) {
            string = new String("CKK_RC5");
        } else if (l == 0L) {
            string = new String("CKK_RSA");
        } else if (l == 27L) {
            string = new String("CKK_SKIPJACK");
        } else if (l == 0x80000000L) {
            string = new String("CKK_VENDOR_DEFINED");
        } else if (l == 4L) {
            string = new String("CKK_X9_42_DH");
        }
        return string;
    }

    public static String retranscritCodeRetour(long l) {
        String string;
        String string2 = string = l == -1L ? "" : "0x" + Functions.toFullHexString((int)((int)l));
        if (string != null) {
            if (string.equalsIgnoreCase("0x00000000") || string.equalsIgnoreCase("CKR_OK")) {
                return "CKR_OK (0x00000000)";
            }
            if (string.equalsIgnoreCase("0x00000001")) {
                return "CKR_CANCEL (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000002")) {
                return "CKR_HOST_MEMORY (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000003")) {
                return "CKR_SLOT_ID_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000005")) {
                return "CKR_GENERAL_ERROR (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000006")) {
                return "CKR_FUNCTION_FAILED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000007")) {
                return "CKR_ARGUMENTS_BAD (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000008")) {
                return "CKR_NO_EVENT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000009")) {
                return "CKR_NEED_TO_CREATE_THREADS (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x0000000A")) {
                return "CKR_CANT_LOCK (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000010")) {
                return "CKR_ATTRIBUTE_READ_ONLY (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000011")) {
                return "CKR_ATTRIBUTE_SENSITIVE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000012")) {
                return "CKR_ATTRIBUTE_TYPE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000013")) {
                return "CKR_ATTRIBUTE_VALUE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000020")) {
                return "CKR_DATA_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000021")) {
                return "CKR_DATA_LEN_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000030")) {
                return "CKR_DEVICE_ERROR (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000031")) {
                return "CKR_DEVICE_MEMORY (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000032")) {
                return "CKR_DEVICE_REMOVED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000040")) {
                return "CKR_ENCRYPTED_DATA_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000041")) {
                return "CKR_ENCRYPTED_DATA_LEN_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000050")) {
                return "CKR_FUNCTION_CANCELED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000051")) {
                return "CKR_FUNCTION_NOT_PARALLEL (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000054")) {
                return "CKR_FUNCTION_NOT_SUPPORTED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000060")) {
                return "CKR_KEY_HANDLE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000062")) {
                return "CKR_KEY_SIZE_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000063")) {
                return "CKR_KEY_TYPE_INCONSISTENT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000064")) {
                return "CKR_KEY_NOT_NEEDED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000065")) {
                return "CKR_KEY_CHANGED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000066")) {
                return "CKR_KEY_NEEDED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000067")) {
                return "CKR_KEY_INDIGESTIBLE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000068")) {
                return "CKR_KEY_FUNCTION_NOT_PERMITTED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000069")) {
                return "CKR_KEY_NOT_WRAPPABLE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x0000006A")) {
                return "CKR_KEY_UNEXTRACTABLE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000070")) {
                return "CKR_MECHANISM_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000071")) {
                return "CKR_MECHANISM_PARAM_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000082")) {
                return "CKR_OBJECT_HANDLE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000090")) {
                return "CKR_OPERATION_ACTIVE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000091")) {
                return "CKR_OPERATION_NOT_INITIALIZED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000A0")) {
                return "CKR_PIN_INCORRECT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000A1")) {
                return "CKR_PIN_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000A2")) {
                return "CKR_PIN_LEN_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000A3")) {
                return "CKR_PIN_EXPIRED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000A4")) {
                return "CKR_PIN_LOCKED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B0")) {
                return "CKR_SESSION_CLOSED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B1")) {
                return "CKR_SESSION_COUNT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B3")) {
                return "CKR_SESSION_HANDLE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B4")) {
                return "CKR_SESSION_PARALLEL_NOT_SUPPORTED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B5")) {
                return "CKR_SESSION_READ_ONLY (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B6")) {
                return "CKR_SESSION_EXISTS (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B7")) {
                return "CKR_SESSION_READ_ONLY_EXISTS (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000B8")) {
                return "CKR_SESSION_READ_WRITE_SO_EXISTS (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000C0")) {
                return "CKR_SIGNATURE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000C1")) {
                return "CKR_SIGNATURE_LEN_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000D0")) {
                return "CKR_TEMPLATE_INCOMPLETE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000D1")) {
                return "CKR_TEMPLATE_INCONSISTENT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000E0")) {
                return "CKR_TOKEN_NOT_PRESENT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000E1")) {
                return "CKR_TOKEN_NOT_RECOGNIZED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000E2")) {
                return "CKR_TOKEN_WRITE_PROTECTED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000F0")) {
                return "CKR_UNWRAPPING_KEY_HANDLE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000F1")) {
                return "CKR_UNWRAPPING_KEY_SIZE_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000000F2")) {
                return "CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000100")) {
                return "CKR_USER_ALREADY_LOGGED_IN (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000101")) {
                return "CKR_USER_NOT_LOGGED_IN (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000102")) {
                return "CKR_USER_PIN_NOT_INITIALIZED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000103")) {
                return "CKR_USER_TYPE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000104")) {
                return "CKR_USER_ANOTHER_ALREADY_LOGGED_IN (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000105")) {
                return "CKR_USER_TOO_MANY_TYPES (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000110")) {
                return "CKR_WRAPPED_KEY_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000112")) {
                return "CKR_WRAPPED_KEY_LEN_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000113")) {
                return "CKR_WRAPPING_KEY_HANDLE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000114")) {
                return "CKR_WRAPPING_KEY_SIZE_RANGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000115")) {
                return "CKR_WRAPPING_KEY_TYPE_INCONSISTENT (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000120")) {
                return "CKR_RANDOM_SEED_NOT_SUPPORTED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000121")) {
                return "CKR_RANDOM_NO_RNG (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000130")) {
                return "CKR_DOMAIN_PARAMS_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000150")) {
                return "CKR_BUFFER_TOO_SMALL (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000160")) {
                return "CKR_SAVED_STATE_INVALID (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000170")) {
                return "CKR_INFORMATION_SENSITIVE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000180")) {
                return "CKR_STATE_UNSAVEABLE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000190")) {
                return "CKR_CRYPTOKI_NOT_INITIALIZED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000191")) {
                return "CKR_CRYPTOKI_ALREADY_INITIALIZED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000001A0")) {
                return "CKR_MUTEX_BAD (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x000001A1")) {
                return "CKR_MUTEX_NOT_LOCKED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x00000200")) {
                return "CKR_FUNCTION_REJECTED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000000")) {
                return "CKR_VENDOR_DEFINED (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000001")) {
                return "Erreur inattendue (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000002")) {
                return "Librairie non charg\u00e9e (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000003")) {
                return "Liste des fonctions PKCS#11 indisponible (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000004")) {
                return "Liste des fonctions PKCS#11 non initialis\u00e9e (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000005")) {
                return "Aucun lecteur pr\u00e9sent (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000006")) {
                return "Aucune carte support\u00e9e (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000008")) {
                return "Utilisateur non authentifi\u00e9 (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000009")) {
                return "Interruption utilisateur (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000010")) {
                return "Code porteur invalide (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000011")) {
                return "La longueur du code porteur est invalide (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000012")) {
                return "CKR_DEMANDE_RECYCLAGE (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000013")) {
                return "Echec de la m\u00e9morisation des cartes connect\u00e9es (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000014")) {
                return "La carte a \u00e9t\u00e9 retrouv\u00e9e (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000015")) {
                return "Carte recherch\u00e9e introuvable (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000016")) {
                return "Op\u00e9ration non conforme (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000017")) {
                return "Objet recherch\u00e9 introuvable (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000018")) {
                return "Objet recherch\u00e9 trouv\u00e9 mais non modifiable (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000019")) {
                return "Aucun objet \u00e0 modifier (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000020")) {
                return "Utilisateur non authentifi\u00e9 (mode sans contact) (" + string + ")";
            }
            if (string.equalsIgnoreCase("0x80000021")) {
                return "Traitement non support\u00e9 en mode sans contact (" + string + ")";
            }
            if (string.length() == 0) {
                return "";
            }
        }
        return null;
    }

    public static String retranscritFlag(long l) {
        String string = "0x" + Functions.toFullHexString((int)((int)l));
        if (string.equalsIgnoreCase("0x80000001")) {
            return "Aucun code erron\u00e9 saisi sur cette carte !";
        }
        if (string.equalsIgnoreCase("0x80000002")) {
            return "Attention un ou plusieurs codes porteurs erron\u00e9s ont d\u00e9j\u00e0 \u00e9t\u00e9 saisis sur cette carte !";
        }
        if (string.equalsIgnoreCase("0x80000003")) {
            return "Attention derni\u00e8re tentative avant blocage du code porteur !";
        }
        if (string.equalsIgnoreCase("0x80000004")) {
            return "Code porteur bloqu\u00e9 !";
        }
        if (string.equalsIgnoreCase("0x80000005")) {
            return "Vous disposez de 3 essais pour saisir le bon code porteur";
        }
        if (string.equalsIgnoreCase("0x80000006")) {
            return "Attention 2 essais restants !";
        }
        if (string.equalsIgnoreCase("0x80000007")) {
            return "Attention 1 essai restant !";
        }
        if (string.equalsIgnoreCase("0x80000008")) {
            return "Aucun code de d\u00e9blocage erron\u00e9 saisi sur cette carte !";
        }
        if (string.equalsIgnoreCase("0x80000009")) {
            return "Attention un ou plusieurs codes de d\u00e9blocage erron\u00e9s ont d\u00e9j\u00e0 \u00e9t\u00e9 saisis sur cette carte !";
        }
        if (string.equalsIgnoreCase("0x80000010")) {
            return "Attention derni\u00e8re tentative avant blocage du code de d\u00e9blocage de la carte !";
        }
        if (string.equalsIgnoreCase("0x80000011")) {
            return "Code de d\u00e9blocage bloqu\u00e9e !";
        }
        if (string.equalsIgnoreCase("0x80000012")) {
            return null;
        }
        if (string.equalsIgnoreCase("0x80000013")) {
            return "La longueur du code porteur saisi est non conforme !";
        }
        if (string.equalsIgnoreCase("0x80000014")) {
            return "Le code porteur saisi est non conforme !";
        }
        if (string.equalsIgnoreCase("0x80000015")) {
            return "Code porteur incorrect !";
        }
        if (string.equalsIgnoreCase("0x80000016")) {
            return null;
        }
        if (string.equalsIgnoreCase("0x80000017")) {
            return "La longueur du code de d\u00e9blocage saisi est non conforme !";
        }
        if (string.equalsIgnoreCase("0x80000018")) {
            return "Le code de d\u00e9blocage saisi est non conforme !";
        }
        if (string.equalsIgnoreCase("0x80000019")) {
            return "Code de d\u00e9blocage incorrect !";
        }
        if (string.equalsIgnoreCase("0x80000020")) {
            return "Les nouveaux codes porteurs diff\u00e8rent !";
        }
        return null;
    }

    public static Color retranscritCouleurFlag(long l) {
        String string = "0x" + Functions.toFullHexString((int)((int)l));
        if (string.equalsIgnoreCase("0x80000001")) {
            return SaisieCodeNbEssais.NIVEAU_OK;
        }
        if (string.equalsIgnoreCase("0x80000002")) {
            return SaisieCodeNbEssais.NIVEAU_ATTENTION;
        }
        if (string.equalsIgnoreCase("0x80000003")) {
            return SaisieCodeNbEssais.NIVEAU_CRITIQUE;
        }
        if (string.equalsIgnoreCase("0x80000004")) {
            return SaisieCodeNbEssais.NIVEAU_KO;
        }
        if (string.equalsIgnoreCase("0x80000005")) {
            return SaisieCodeNbEssais.NIVEAU_OK;
        }
        if (string.equalsIgnoreCase("0x80000006")) {
            return SaisieCodeNbEssais.NIVEAU_ATTENTION;
        }
        if (string.equalsIgnoreCase("0x80000007")) {
            return SaisieCodeNbEssais.NIVEAU_CRITIQUE;
        }
        if (string.equalsIgnoreCase("0x80000008")) {
            return SaisieRecyclage.NIVEAU_OK;
        }
        if (string.equalsIgnoreCase("0x80000009")) {
            return SaisieRecyclage.NIVEAU_ATTENTION;
        }
        if (string.equalsIgnoreCase("0x80000010")) {
            return SaisieRecyclage.NIVEAU_CRITIQUE;
        }
        return null;
    }

    public static Resultat rechercheObjets(Application application, int n, String string, boolean bl) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        if (application.getSessionCourante() != null) {
            Vector<Object> vector = new Vector<Object>();
            if (n == 4 && application.getFiltresObjets() != null && application.getFiltresObjets().size() > 0) {
                for (String string2 : application.getFiltresObjets()) {
                    Resultat resultat2 = RechercheObjets.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), n, string2);
                    if (resultat2 == null || resultat2.getCodeRetourStr() == null || !resultat2.getCodeRetourStr().startsWith("CKR_OK") || application.getSessionCourante() == null || application.getSessionCourante().getIdToken() == null) continue;
                    for (Object object : resultat2.getObjets()) {
                        if (vector.contains(resultat2.getObjets())) continue;
                        vector.add(object);
                    }
                }
            }
            if ((resultat = RechercheObjets.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), n, string)) != null && bl) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && application.getSessionCourante() != null && application.getSessionCourante().getIdToken() != null) {
                application.ajouteFiltreObjet(string);
                application.supprimeTousLesObjetsDeType(application.getSessionCourante().getIdToken(), n);
                vector.addAll(resultat.getObjets());
                application.ajouteLesObjets(application.getLibrairieP11(), application.getSessionCourante(), application.getSessionCourante().getIdToken(), vector, n);
            }
        } else {
            log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de recherche de l'objet : Il n'y a pas de session en cours");
            application.notifieException(new ExceptionTraitement(25, "Une erreur inattendue est survenue"));
        }
        return resultat;
    }

    static {
        int n;
        log = Logger.getLogger(TraitementsUtil.class);
        caracteresHexa = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        nibbleCorrespondant = new byte[103];
        for (n = 0; n <= 102; ++n) {
            TraitementsUtil.nibbleCorrespondant[n] = -1;
        }
        for (n = 48; n <= 57; ++n) {
            TraitementsUtil.nibbleCorrespondant[n] = (byte)(n - 48);
        }
        for (n = 65; n <= 70; ++n) {
            TraitementsUtil.nibbleCorrespondant[n] = (byte)(n - 65 + 10);
        }
        for (n = 97; n <= 102; ++n) {
            TraitementsUtil.nibbleCorrespondant[n] = (byte)(n - 97 + 10);
        }
    }
}

